/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
//
// Adapted further by allowing wobble control parameters
// to be passed to the shader from the .scn file and for
// independant X and Y wobbles to be applied.  The Emu.

/////////////////////////////////////////////////////////////////////////////////

// Standard shader inputs

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Inputs from the VGHD .scn file.

uniform vec4 wobble_x; // Amplitude, spatial freq, temporal freq, phase
uniform vec4 wobble_y; // Amplitude, spatial freq, temporal freq, phase

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

float wobble ( float q, vec4 a )
 { return a.x * sin ( iGlobalTime*a.y + q*a.z + a.w);
 }

void main(void)
{
	vec2 uv = -gl_FragCoord.xy / iResolution.xy;

   uv.x += wobble(uv.y,wobble_x);
   uv.y += wobble(uv.x,wobble_y);

	gl_FragColor = texture2D(iChannel0,uv);
}